#include <iostream>
#include <stdlib.h>

#include <cuda_runtime.h>
#include <vector_types.h>

using namespace std;

extern "C" void cudaTest(int* a, int* b, int aL);
extern "C" void nBody(float4* a, float3* b, int nBodies);

int main()
{
	/* This portion of the sample code presents a simple vector addition performed on the
	GPU using CUDA. The C++ portions of this code should be simple enough for you to
	follow: we declare a pair of integer arrays, call the externalised function "cudaTest", and
	print out the results in char form.
	
	The problematic portions of this example are actually in the setup. When embedding CUDA
	functions in your C++ program, you need to link the CUDA libraries appropriately. You
	start by right-clicking on your project, selecting 'Build Customizations', and checking the
	box for the version of CUDA you are targeting. Next, you need to go into project Properties
	and add "$(CUDA_LIB_PATH);../../common/lib" to

	Configuration Properties -> Linker -> General -> Additional Library Directories

	and make sure Configuration Properties -> Linker -> Input -> Additional Dependencies

	ends with "cudart.lib;%(AdditionalDependencies)"

	If you have problems with this, don't worry - this project has all of these settings sorted
	in advance for you, so you can use it as a basis for any embedded CUDA work you want to
	include in your C++ programming going forward */

	const int arrayLength = 52;
	
	int a[arrayLength] = {	67, 85, 68, 65, 32, 100, 105, 100, 32, 110, 111, 116,
							32, 119, 111, 114, 107, 33, 32, 68, 105, 100, 32, 121,
							111, 117, 32, 99, 111, 112, 121, 32, 116, 104, 101, 32,
							99, 111, 100, 101, 32, 99, 111, 114, 114, 101, 99, 116,
							108, 121, 63, 32	};

	int b[arrayLength] = {	0, 26, 42, 38, 82, -3, 11, 17, 76, -13, 5, -11,
							79, -9, 4, -81, -75, 51, 72, 33, -73, 7, 69, -7,
							-1, -16, 76, -67, -6, 3, -89, 67, -5, 7, 6, 73,
							11, -8, -68, 18, 73, 17, -7, -82, -15, 3, 6, -17,
							-1, -20, 47, 1	};

	cudaTest(a, b, arrayLength);		// Here's where we call our CUDA function. See what happens
										// if you comment it out!

	for(int i = 0; i < arrayLength; i++)
	{
		cout << char(a[i]);			// This cout lets us check our code is working. Try experimenting!
	}

	cout << "\n\n" << "Input a number and press Enter to quit" << "\n\n";
																	
																	// This is a little catch-all to
	char x;															// let us check the console before
																	// the program ends

	cin >> x;

	/* These next bits of code are commented out so that you can experiment with them once you're
	comfortable with the simple vector addition we discuss above. In this code, we introduce a
	predefined struct that is often used in GPU physics, the float4, referenced in the declared
	external function nBody. Your mission for this afternoon, should you choose to accept it, is
	to write a function nBody in kernel.cu that you call from main.cpp. You will pass it one array
	of float4s and one of float3s (as introduced below), and the number of bodies in the system. The
	bones of a __global__ function called nBodyKernel are included in kernel.cu, to give you a place
	to start, along with a __device__ function that you might find useful... */

	
	/*
	float4 objectProperties;		// Consider this a container of your object's 'physical'
									// properties at the time you wish to calculate the gravitational
									// attraction it is experiencing from all other objects in your
									// system

	objectProperties.x = 100.0f;	// Object's x-coordinate in Cartesian space
	objectProperties.y = 300.0f;	// Object's y-coordinate in Cartesian space
	objectProperties.z = 250.0f;	// Object's z-coordinate in, you guessed it, Cartesian space
	objectProperties.w = 2.5f;		// Object's mass
	

	float3 objectAccel;				// This is going to be the resultant acceleration your object is
									// experiencing as a result of its proximity to other objects.
									// We default this to zero because we haven't yet worked it out.

	objectForce.x = 0.0f;			// We separate the resultant acceleration into three components
	objectForce.y = 0.0f;			// to make it easily integrated with our Cartesian physics model.
	objectForce.z = 0.0f;
	*/
	
	
}